
Class HUD
	
	Private
	
	Global FuelTextColor:Color = Color.Green ' Text colour for fuel display
	
	Global BlackoutAlpha:Float = 0.0
	
	Public
	
	Function Blackout:Float ()
		
		BlackoutAlpha = BlackoutAlpha + 0.002
		If BlackoutAlpha > 1.0 Then BlackoutAlpha = 1.0
		
		Return BlackoutAlpha
		
	End
	
	Function ResetBlackout ()
		BlackoutAlpha = 0.0
	End
	
	Function RenderText (canvas:Canvas)
		
		canvas.Color = Color.Black
		canvas.Alpha = BlackoutAlpha
		
		canvas.DrawRect (App.ActiveWindow.Rect)
		
		canvas.Alpha = 1.0
		canvas.Color = Color.White
		
		ShadowText (canvas, "FPS: " + App.FPS, 20.0, 20.0)

		ShadowText (canvas, "Left/right cursors to move Player; SPACE to boost", 20.0, 60.0)
		ShadowText (canvas, "O to toggle orb", 20.0, 80.0)
		ShadowText (canvas, "R to reset!", 20.0, 100.0)

		ShadowText (canvas, "TEMP: H to halve fuel", 20.0, 120.0)

		If Game.Player.Fuel = 0.0
			FuelTextColor = Color.Grey
		Elseif Game.Player.Fuel > 50.0
			FuelTextColor = Color.Green
		Elseif Game.Player.Fuel <= 25.0
			FuelTextColor = Color.Red
		Elseif Game.Player.Fuel <= 50.0
			FuelTextColor = Color.Orange
		Endif
		
		ShadowText (canvas, "Fuel: " + Int (Game.Player.Fuel), 20.0, 160.0, FuelTextColor)

		canvas.Color = Color.White

		ShadowText (canvas, "Space gems: " + Game.CurrentLevel.SpaceGemsCollected + " / " + Game.CurrentLevel.SpaceGemCount, 20.0, 200)
		
'		ShadowText (canvas, Player.model.Position, 200, 180)
'		ShadowText (canvas, "vel: " + Player.body.LinearVelocity, 20.0, 140.0)
'		ShadowText (canvas, "cmpos: " + cam.Position, 20.0, 200.0)

	End

End
